// const card = document.getElementById("card");

// card.addEventListener("click", flipCard);

// function flipCard(){
//     card.classList.toggle("flip");
// }

document.querySelectorAll('.flip-card-inner').forEach(item => {

    item.addEventListener('click', flipCard);
    item.addEventListener('keydown', (event) => {
        if (event.key === " " || event.key === "Enter" || event.key === "Spacebar") {
            // Prevent the default action to stop scrolling when space is pressed
            event.preventDefault();
            toggleButton(event.target);
          }
    });

    function toggleButton(element) {

        // Check to see if the button is pressed
        const pressed = element.getAttribute("aria-pressed") === "true";
      
        // Change aria-pressed to the opposite state
        element.setAttribute("aria-pressed", !pressed);
      
        // Toggle the play state of the audio file
        flipCard();
      }



    function flipCard(){
        item.classList.toggle("flip");
    }
  })


