// Generated by CoffeeScript 1.10.0
(function () {
	var D2LDEBUG, bind = function (fn, me) {
		return function () {
			return fn.apply(me, arguments);
		};
	};
	D2LDEBUG = true;
	/**
	 *
	 * The GraphicSelectApp Class contains all of the main features and properties for the Graphic multi select.
	 *
	 * @class GraphicSelectApp
	 *
	 * @author Justin Schlumkoski
	 *
	 * @since 06/18/2015
	 *
	 */
	window.GraphicSelectApp = (function () {
		/**
		 *
		 * Holds string loction of the default data file.
		 *
		 * @property _defaultQuestionFile
		 *
		 * @type {String}
		 *
		 * @default void 0
		 *
		 */
		GraphicSelectApp.prototype._defaultQuestionFile = "data/multiselectDefaultData.txt";
		/**
		 *
		 * Holds string loction of the data file.
		 *
		 * @property _questionFile
		 *
		 * @type {String}
		 *
		 * @default void 0
		 *
		 */
		GraphicSelectApp.prototype._questionFile = void 0;
		/**
		 *
		 * Holds the parsed JSON data. Object.
		 *
		 * @property AppData
		 *
		 * @type {Object}
		 *
		 * @default undefined
		 *
		 */
		GraphicSelectApp.prototype._appData = void 0;
		/**
		 *
		 * Holds the number of times the activity has been played.
		 *
		 * @property _currentAttempts
		 *
		 * @type {Interger}
		 *
		 * @default 0
		 *
		 */
		GraphicSelectApp.prototype._currentAttempts = 0;
		/**
		 *
		 * Holds the id of the container for the activity.
		 *
		 * @property containerRef
		 *
		 * @type {String}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._containerRef = null;
		/**
		 *
		 * Holds the DOm referance of the container for the activity.
		 *
		 * @property _appContainer
		 *
		 * @type {Object}
		 *
		 * @default void 0
		 *
		 */
		GraphicSelectApp.prototype._appContainer = void 0;
		/**
		 *
		 * Holds whether or not the activity is being accessed on a mobile device.
		 *
		 * @property _mobileDevice
		 *
		 * @type {Boolean}
		 *
		 * @default false
		 *
		 */
		GraphicSelectApp.prototype._mobileDevice = false;
		/**
		 *
		 * Holds whether the end report has been displayed.
		 *
		 * @property _finalReport
		 *
		 * @type {Boolean}
		 *
		 * @default false
		 *
		 */
		GraphicSelectApp.prototype._finalReport = false;
		/**
		 *
		 * Holds whether continuous feedback is required.
		 *
		 * @property _continuousFeedback
		 *
		 * @type {Boolean}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._continuousFeedback = null;
		/**
		 *
		 * Holds whether report feedback after each question is required.
		 *
		 * @property _reportFeedback
		 *
		 * @type {Boolean}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._reportFeedback = null;
		/**
		 *
		 * Holds whether an end report is required.
		 *
		 * @property _endReport
		 *
		 * @type {Boolean}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._endReport = null;
		/**
		 *
		 * Tab index - Holds the tab index.
		 *
		 * @property _tabIndex
		 *
		 * @type {Integer}
		 *
		 * @default 2
		 *
		 */
		GraphicSelectApp.prototype._tabIndex = 2;
		/**
		 *
		 * Holds the current question number.
		 *
		 * @property _currentQuestion
		 *
		 * @type {Integer}
		 *
		 * @default 0
		 *
		 */
		GraphicSelectApp.prototype._currentQuestion = 0;
		/**
		 *
		 * Holds the current page number.
		 *
		 * @property _pageNum
		 *
		 * @type {Integer}
		 *
		 * @default 0
		 *
		 */
		GraphicSelectApp.prototype._pageNum = 0;
		/**
		 *
		 * Holds the parameters for the restart button.
		 *
		 * @property _restartButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._restartButton = null;
		/**
		 *
		 * Holds the parameters for the start button.
		 *
		 * @property _startButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._startButton = null;
		/**
		 *
		 * Holds the parameters for the next button.
		 *
		 * @property _nextButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._nextButton = null;
		/**
		 *
		 * Holds the parameters for the back button.
		 *
		 * @property backButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._backButton = null;
		/**
		 *
		 * Holds the parameters for the instructions button.
		 *
		 * @property instructionButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._instructionButton = null;
		/**
		 *
		 * Holds the parameters for the submit all button.
		 *
		 * @property _submitAllButton
		 *
		 * @type {Object}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._submitAllButton = null;
		/**
		 *
		 * Holds the interval used to determine if all questions have been submitted.
		 *
		 * @property _submitInterval
		 *
		 * @type {Event}
		 *
		 * @default null
		 *
		 */
		GraphicSelectApp.prototype._submitInterval = null;
		/**
		 *
		 * Holds whether the activity is being accessed on IE
		 *
		 * @property usingIE
		 *
		 * @type {Boolean}
		 *
		 * @default false
		 *
		 */
		GraphicSelectApp.prototype._usingIE = false;
		/**
		 *
		 * Temporary array used to build the array of user answers.
		 *
		 * @property _questionCheck
		 *
		 * @type {Array}
		 *
		 * @default empty
		 *
		 */
		GraphicSelectApp.prototype._questionCheck = [];
		/**
		 *
		 * Array that holds the users answers for each question.
		 *
		 * @property _allCheck
		 *
		 * @type {Array}
		 *
		 * @default empty
		 *
		 */
		GraphicSelectApp.prototype._allCheck = [];
		/**
		 *
		 * Temporary array used to build the array of correct answers.
		 *
		 * @property _correctAnswers
		 *
		 * @type {Array}
		 *
		 * @default empty
		 *
		 */
		GraphicSelectApp.prototype._correctAnswers = [];
		/**
		 *
		 * Array that holds the correct answers for each question.
		 *
		 * @property _allCorrect
		 *
		 * @type {Array}
		 *
		 * @default empty
		 *
		 */
		GraphicSelectApp.prototype._allCorrect = [];
		/**
		 *
		 * Array that holds whether each question has been submitted.
		 *
		 * @property _submitCheck
		 *
		 * @type {Array}
		 *
		 * @default empty
		 *
		 */
		GraphicSelectApp.prototype._submitCheck = [];
		/**
		 *
		 * base level of headings wich will be added to the app
		 *
		 * @property _headingLevel
		 *
		 * @type {Integer}
		 *
		 * @default 1
		 *
		 */
		GraphicSelectApp.prototype._headingLevel = 1;
		GraphicSelectApp.prototype._noPost = null;
		/**
		 *
		 * Constuctor will define the binds for this class
		 *
		 * @method GraphicSelectApp
		 *
		 */
		function GraphicSelectApp() {
			this.HandleResizeEvent = bind(this.HandleResizeEvent, this);
			this.mergeObjectData = bind(this.mergeObjectData, this);
			this.msieversion = bind(this.msieversion, this);
			this.buildAnswerReferences = bind(this.buildAnswerReferences, this);
			this.shuffle = bind(this.shuffle, this);
			this.validateYouTubeLink = bind(this.validateYouTubeLink, this);
			this.EmbedMedia = bind(this.EmbedMedia, this);
			this.CheckAllSubmits = bind(this.CheckAllSubmits, this);
			this.buildReportButtons = bind(this.buildReportButtons, this);
			this.buildReport = bind(this.buildReport, this);
			this.BuildFeedback = bind(this.BuildFeedback, this);
			this.BuildResultTable = bind(this.BuildResultTable, this);
			this.GetQuestionScore = bind(this.GetQuestionScore, this);
			this.GetQuestionTotal = bind(this.GetQuestionTotal, this);
			this.BuildMiniReport = bind(this.BuildMiniReport, this);
			this.GenerateQuestionFeedback = bind(this.GenerateQuestionFeedback, this);
			this.ResetQuestionAnswers = bind(this.ResetQuestionAnswers, this);
			this.CheckAnswer = bind(this.CheckAnswer, this);
			this.HandleKeyboardSelection = bind(this.HandleKeyboardSelection, this);
			this.HandleSelection = bind(this.HandleSelection, this);
			this.addQuestions = bind(this.addQuestions, this);
			this.buildTable = bind(this.buildTable, this);
			this.buildInstructions = bind(this.buildInstructions, this);
			this.toggleInstructions = bind(this.toggleInstructions, this);
			this.buildActivityButtons = bind(this.buildActivityButtons, this);
			this.buildActivity = bind(this.buildActivity, this);
			this.buildPostActivityButtons = bind(this.buildPostActivityButtons, this);
			this.buildPostActivity = bind(this.buildPostActivity, this);
			this.buildPreActivityButtons = bind(this.buildPreActivityButtons, this);
			this.buildPreActivity = bind(this.buildPreActivity, this);
			this.clearStage = bind(this.clearStage, this);
			this.loadButtons = bind(this.loadButtons, this);
			this.buildAppFrame = bind(this.buildAppFrame, this);
			this.buildApp = bind(this.buildApp, this);
			this.getAppData = bind(this.getAppData, this);
			this.setupApp = bind(this.setupApp, this);
			this.resetActivityData = bind(this.resetActivityData, this);
			return;
		}
		/**
		 *
		 * Resets specified properties to their default values.
		 *
		 * @method resetActivityData
		 *
		 */
		GraphicSelectApp.prototype.resetActivityData = function () {
			this._currentQuestion = 0;
			this._pageNum = 0;
			this._finalReport = false;
			this._submitInterval = null;
			this._tabIndex = 2;
			this._allCheck = [];
			this._allCorrect = [];
			this._submitCheck = [];
		};
		/**
		 *
		 * Establishes the JSON text file path, the id of the container that houses the activity, and makes a call to get the activity data.
		 *
		 * @method setupApp
		 *
		 * @param {String} file
		 *
		 * @param {String} location
		 *
		 */
		GraphicSelectApp.prototype.setupApp = function (file, location) {
			this._questionFile = file;
			if (document.getElementById(location) !== null) {
				this._containerRef = document.getElementById(location);
				this.getAppData((function (_this) {
					return function () {
						return _this.getAppData(_this.buildApp, _this._questionFile);
					};
				})(this), this._defaultQuestionFile);
			} else {
				this.d2log('Error! Missing Proper DOM object.');
			}
		};
		/**
		 *
		 * Retrieves the activity data from the JSON text file, passes that data to build the activity.
		 *
		 * @method getAppData
		 * 
		 * @param {function} callback
		 *
		 */
		GraphicSelectApp.prototype.getAppData = function (callback, fileRef) {
			var jqxhr;
			jqxhr = $.getJSON(fileRef, (function (_this) {
				return function (data) {
					if (!_this._appData) {
						_this._appData = data;
					} else {
						_this._appData = _this.mergeObjectData(data.valueOf(), _this._appData.valueOf());
					}
					callback(_this._appData);
				};
			})(this));
			jqxhr.fail((function (_this) {
				return function (e) {
					_this.d2log('ERROR!!: failed to load data from specified file. Ensure file is at that location and that JSON data is vaild. (tip: use a vaildator like: http://jsonformatter.curiousconcept.com/ )');
					_this.d2log(e);
				};
			})(this));
		};
		/**
		 *
		 * Checks if the activity is being accessed on a mobile device or Internet Explorer and
		 * sets up other necessary things for the entire activity.
		 *
		 * @method buildApp
		 *
		 */
		GraphicSelectApp.prototype.buildApp = function () {
			var hl;
			if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
				this._mobileDevice = true;
			}
			this._usingIE = this.msieversion();
			hl = parseInt(this._appData.HeadingLevel);
			if (isNaN(hl) || hl < 1) {
				hl = 1;
			}
			if (hl > 2) {
				hl = 2;
			}
			this._headingLevel = hl;
			this._continuousFeedback = this._appData.ProvideContinuous;
			this._reportFeedback = this._appData.ProvideQuestionReport;
			this._endReport = this._appData.ProvideEndReport;
			if (this._continuousFeedback === false) {
				if (this._appData.QuestionDisplay === 'all') {
					if (this._endReport === false) {
						this._continuousFeedback = true;
					}
				} else if (this._appData.QuestionDisplay === 'single') {
					if (this._reportFeedback === false && this._endReport === false) {
						this._continuousFeedback = true;
					}
				}
			}
			this.Questions = this._appData.Questions;
			if (this._appData.Randomize === true) {
				this.shuffle(this.Questions);
			}
			if (this._appData.PostActivityText === 'none' || this._appData.PostActivityText === undefined || this._appData.PostActivityText === null || this._appData.PostActivityText === '') {
				if (this._appData.PostActivityMedia === 'none' || this._appData.PostActivityMedia === undefined || this._appData.PostActivityMedia === null || this._appData.PostActivityMedia === '') {
					this._noPost = true;
				} else {
					this._noPost = false;
				}
			} else {
				this._noPost = false;
			}
			this.buildAppFrame();
			this.loadButtons();
			this.buildAnswerReferences();
			if (this._appData.PreActivityText === 'none') {
				if (this._appData.PreActivityMedia === 'none') {
					this.buildActivity();
				} else {
					this.buildPreActivity();
				}
			} else {
				this.buildPreActivity();
			}
			this.HandleResizeEvent();
			$(this._containerRef).addClass('rs_preserve');
		};
		/**
		 *
		 * Sets up the initial containers for the app.
		 *
		 * @method buildAppFrame
		 *
		 */
		GraphicSelectApp.prototype.buildAppFrame = function () {
			var GS_container, GS_content, GS_header;
			GS_container = document.createElement('section');
			GS_container.id = 'GS_container';
			GS_content = document.createElement('section');
			GS_content.id = 'GS_content';
			GS_header = document.createElement('section');
			GS_header.id = 'GS_header';
			GS_header.innerHTML = ('<h' + this._headingLevel + '>') + this._appData.ActivityName + ('</h' + this._headingLevel + '>');
			GS_container.appendChild(GS_content);
			$(GS_container).appendTo(this._containerRef);
			$(GS_header).hide().appendTo(GS_content).slideDown(500, 'swing');
			// GS_content.appendChild(GS_header);
			this._appContainer = document.createElement('div');
			this._appContainer.id = 'GS_appContainer';
			GS_content.appendChild(this._appContainer);
		};
		/**
		 *
		 * Sets up all the parameters for each button and stores them in an object.
		 *
		 * @method loadButtons
		 *
		 */
		GraphicSelectApp.prototype.loadButtons = function () {
			var GS_backButton, GS_backLabel, GS_buttonIcon, GS_instructionButton, GS_nextButton, GS_nextLabel, GS_restartButton, GS_restartLabel, GS_startButton, GS_startLabel, GS_submitAllButton, GS_submitAllLabel;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_restartButton = document.createElement('button');
			GS_restartButton.id = 'GS_restartButton';
			GS_restartButton.setAttribute('class', 'GS_button');
			GS_restartButton.setAttribute('title', 'Restarts the Activity');
			GS_restartButton.onclick = (function (_this) {
				return function () {
					_this.clearStage();
					_this.resetActivityData();
					_this.buildAnswerReferences();
					if (_this._appData.PreActivityText === 'none') {
						if (_this._appData.PreActivityMedia === 'none') {
							_this.buildActivity();
							_this.scrollViewToTop();
						} else {
							_this.buildPreActivity();
							_this.scrollViewToTop();
						}
					} else {
						_this.buildPreActivity();
					}
				};
			})(this);
			GS_restartLabel = document.createElement('span');
			GS_restartLabel.setAttribute('class', 'GS_buttonLabel');
			GS_restartLabel.innerHTML = 'Restart Activity';
			GS_restartButton.appendChild(GS_buttonIcon);
			GS_restartButton.appendChild(GS_restartLabel);
			this._restartButton = GS_restartButton;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_startButton = document.createElement('button');
			GS_startButton.id = 'GS_startButton';
			GS_startButton.setAttribute('class', 'GS_button');
			GS_startButton.setAttribute('title', 'Starts the Activity');
			GS_startButton.onclick = (function (_this) {
				return function () {
					_this.clearStage();
					_this._pageNum++;
					_this.buildActivity();
					_this.scrollViewToTop();
				};
			})(this);
			GS_startLabel = document.createElement('span');
			GS_startLabel.setAttribute('class', 'GS_buttonLabel');
			GS_startLabel.innerHTML = 'Start Activity';
			GS_startButton.appendChild(GS_buttonIcon);
			GS_startButton.appendChild(GS_startLabel);
			this._startButton = GS_startButton;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_nextButton = document.createElement('button');
			GS_nextButton.id = 'GS_nextButton';
			GS_nextButton.setAttribute('class', 'GS_button');
			GS_nextButton.setAttribute('title', 'Moves to the Next Part of the Activity');
			GS_nextButton.onclick = (function (_this) {
				return function () {
					var i;
					_this._currentQuestion++;
					_this._pageNum++;
					if (_this._appData.QuestionDisplay === 'single') {
						if (_this._reportFeedback === false && _this._endReport === true && _this._finalReport === false) {
							_this.CheckAnswer(_this._currentQuestion - 1, 'next');
						}
						if (_this._currentQuestion < _this.Questions.length) {
							_this.clearStage();
							_this.buildActivity();
							_this.scrollViewToTop();
						} else {
							if (_this._endReport === true) {
								if (_this._finalReport === false) {
									_this._finalReport = true;
									_this.clearStage();
									_this.buildReport();
								} else {
									if (_this._noPost === true) {
										_this.clearStage();
										_this.resetActivityData();
										_this.buildAnswerReferences();
										if (_this._appData.PreActivityText === 'none') {
											if (_this._appData.PreActivityMedia === 'none') {
												_this.buildActivity();
												_this.scrollViewToTop();
											} else {
												_this.buildPreActivity()
												_this.scrollViewToTop();
											}
										} else {
											_this.buildPreActivity();
											_this.scrollViewToTop();
										}
									} else {
										_this.clearStage();
										_this.buildPostActivity();
										_this._currentAttempts++;
										_this.scrollViewToTop();
									}
								}
							} else {
								if (_this._noPost === true) {
									_this.clearStage();
									_this.resetActivityData();
									_this.buildAnswerReferences();
									if (_this._appData.PreActivityText === 'none') {
										if (_this._appData.PreActivityMedia === 'none') {
											_this.buildActivity();
											_this.scrollViewToTop();
										} else {
											_this.buildPreActivity();
											_this.scrollViewToTop();
										}
									} else {
										_this.buildPreActivity();
										_this.scrollViewToTop();
									}
								} else {
									_this.clearStage();
									_this.buildPostActivity();
									_this.scrollViewToTop();
									_this._currentAttempts++;
								}
							}
						}
					} else if (_this._appData.QuestionDisplay === 'all') {
						i = 0;
						while (i < _this.Questions.length) {
							_this.CheckAnswer(i, 'next');
							i++;
						}
						clearInterval(_this._submitInterval);
						if (_this._finalReport === false) {
							if (_this._endReport === true) {
								_this._finalReport = true;
								_this.clearStage();
								_this.buildReport();
							} else {
								if (_this._noPost === true) {
									_this.clearStage();
									_this.resetActivityData();
									_this.buildAnswerReferences();
									if (_this._appData.PreActivityText === 'none') {
										if (_this._appData.PreActivityMedia === 'none') {
											_this.buildActivity();
											_this.scrollViewToTop();
										} else {
											_this.buildPreActivity();
											_this.scrollViewToTop();
										}
									} else {
										_this.buildPreActivity();
										_this.scrollViewToTop();
									}
								} else {
									_this.clearStage();
									_this.buildPostActivity();
									_this.scrollViewToTop();
									_this._currentAttempts++;
								}
							}
						} else {
							if (_this._noPost === true) {
								_this.clearStage();
								_this.resetActivityData();
								_this.buildAnswerReferences();
								if (_this._appData.PreActivityText === 'none') {
									if (_this._appData.PreActivityMedia === 'none') {
										_this.buildActivity();
										_this.scrollViewToTop();
									} else {
										_this.buildPreActivity();
										_this.scrollViewToTop();
									}
								} else {
									_this.buildPreActivity();
									_this.scrollViewToTop();
								}
							} else {
								_this.clearStage();
								_this.buildPostActivity();
								_this.scrollViewToTop();
								_this._currentAttempts++;
							}
						}
					}
					_this.HandleResizeEvent();
				};
			})(this);
			GS_nextLabel = document.createElement('span');
			GS_nextLabel.setAttribute('class', 'GS_buttonLabel');
			GS_nextButton.appendChild(GS_buttonIcon);
			GS_nextButton.appendChild(GS_nextLabel);
			this._nextButton = GS_nextButton;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_backButton = document.createElement('button');
			GS_backButton.id = 'GS_backButton';
			GS_backButton.setAttribute('class', 'GS_button');
			GS_backButton.setAttribute('title', 'Moves to the Previous Part of the Activity');
			GS_backButton.onclick = (function (_this) {
				return function () {
					_this.clearStage();
					_this._currentQuestion--;
					_this._pageNum--;
					if (_this._currentQuestion < 0) {
						_this._currentQuestion = 0;
					}
					if (_this._pageNum === 0) {
						if (_this._appData.PreActivityText === 'none' && _this._appData.PreActivityMedia === 'none') {
							_this.buildActivity();
							_this.scrollViewToTop();
						} else {
							_this.buildPreActivity();
							_this.scrollViewToTop();
						}
					} else {
						_this.buildActivity();
						_this.scrollViewToTop();
					}
				};
			})(this);
			GS_backLabel = document.createElement('span');
			GS_backLabel.setAttribute('class', 'GS_buttonLabel');
			GS_backLabel.innerHTML = 'Go Back';
			GS_backButton.appendChild(GS_buttonIcon);
			GS_backButton.appendChild(GS_backLabel);
			this._backButton = GS_backButton;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_instructionButton = document.createElement('button');
			GS_instructionButton.id = 'GS_instructionButton';
			GS_instructionButton.alt = 'Instruction toggle';
			GS_instructionButton.setAttribute('class', 'GS_button');
			GS_instructionButton.setAttribute('title', 'Toggles the Instructions');
			GS_instructionButton.onclick = (function (_this) {
				return function () {
					_this.toggleInstructions();
				};
			})(this);
			this._instructionButton = GS_instructionButton;
			GS_buttonIcon = document.createElement('div');
			GS_buttonIcon.setAttribute('class', 'GS_buttonIcon');
			GS_submitAllButton = document.createElement('button');
			GS_submitAllButton.id = 'GS_submitAllButton';
			GS_submitAllButton.setAttribute('class', 'GS_button');
			GS_submitAllButton.setAttribute('title', 'Submits all answers at once');
			GS_submitAllButton.onclick = (function (_this) {
				return function () {
					var i;
					i = 0;
					while (i < _this.Questions.length) {
						if (document.getElementById('GS_submitButton' + i).disabled === false) {
							$('#GS_submitButton' + i).click();
						}
						i++;
					}
					document.getElementById('GS_nextButton').disabled = false;
					clearInterval(_this._submitInterval);
				};
			})(this);
			GS_submitAllLabel = document.createElement('span');
			GS_submitAllLabel.setAttribute('class', 'GS_buttonLabel');
			GS_submitAllLabel.innerHTML = 'Submit All';
			GS_submitAllButton.appendChild(GS_buttonIcon);
			GS_submitAllButton.appendChild(GS_submitAllLabel);
			this._submitAllButton = GS_submitAllButton;
		};
		/**
		 *
		 * Clears the app container.
		 *
		 * @method clearStage
		 *
		 */
		GraphicSelectApp.prototype.clearStage = function () {
			$('#GS_appContainer').empty();
		};		
		/**
		 *
		 * Builds the pre activity inside of the app container.
		 *
		 * @method buildPreActivity
		 *
		 */
		GraphicSelectApp.prototype.buildPreActivity = function () {
			var GS_preActivityText, hasImage, hasVideo, i;
			hasImage = false;
			hasVideo = false;
			if (this._appData.PreActivityText !== 'none') {
				GS_preActivityText = document.createElement('p');
				GS_preActivityText.id = 'GS_preActivityText';
				GS_preActivityText.innerHTML = this._appData.PreActivityText;
				$(GS_preActivityText).hide().appendTo(this._appContainer).fadeIn(500);
				//this._appContainer.appendChild(GS_preActivityText);
			}
			if (this._appData.PreActivityMedia !== 'none') {
				i = 0;
				while (i < this._appData.PreActivityMedia.length) {
					if (this._appData.PreActivityMedia[i].type === 'image') {
						hasImage = true;
					} else if (this._appData.PreActivityMedia[i].type === 'YouTubeVideo') {
						hasVideo = true;
					}
					this.EmbedMedia('page', this._appContainer, this._appData.PreActivityMedia[i]);
					i++;
				}
			}
			if (hasVideo === false && hasImage === false) {
				this.buildPreActivityButtons();
			} else {
				$('.embedMedia:last').one("load", function (_this) {
					return function () {
						_this.buildPreActivityButtons();
						_this.HandleResizeEvent();
					};
				}(this));
			}
			$('#head').attr('tabindex', '1').css('outline', 'none');
			$('#head').focus();

			this.scrollViewToTop();
		};
		/**
		 *
		 * Adds the button(s) for the pre activity into the app container.
		 *
		 * @method buildPreActivityButtons
		 *
		 */
		GraphicSelectApp.prototype.buildPreActivityButtons = function () {
			var GS_buttonSet;
			GS_buttonSet = document.createElement('div');
			GS_buttonSet.id = 'GS_buttonSet';
			this._appContainer.appendChild(GS_buttonSet);
			GS_buttonSet.appendChild(this._startButton);
		};
		/**
		 *
		 * Builds the post activity inside of the app container.
		 *
		 * @method buildPostActivity
		 *
		 */
		GraphicSelectApp.prototype.buildPostActivity = function () {
			var GS_postActivityText, hasImage, hasVideo, i;
			hasImage = false;
			hasVideo = false;
			GS_postActivityText = void 0;
			if (this._appData.PostActivityText !== 'none') {
				GS_postActivityText = document.createElement('p');
				GS_postActivityText.id = 'GS_postActivityText';
				GS_postActivityText.innerHTML = this._appData.PostActivityText;
				$(GS_postActivityText).hide().appendTo(this._appContainer).fadeIn(500);
				//this._appContainer.appendChild(GS_postActivityText);
			} else {
				GS_postActivityText = document.createElement('p');
				GS_postActivityText.id = 'GS_postActivityText';
				GS_postActivityText.innerHTML = 'You have completed the activity!';
				$(GS_postActivityText).hide().appendTo(this._appContainer).fadeIn(500);
				//this._appContainer.appendChild(GS_postActivityText);
			}
			if (this._appData.PostActivityMedia !== 'none') {
				i = 0;
				while (i < this._appData.PostActivityMedia.length) {
					if (this._appData.PostActivityMedia[i].type === 'image') {
						hasImage = true;
					} else if (this._appData.PostActivityMedia[i].type === 'YouTubeVideo') {
						hasVideo = true;
					}
					this.EmbedMedia('page', this._appContainer, this._appData.PostActivityMedia[i]);
					i++;
				}
			}
			if (hasVideo === false && hasImage === false) {
				this.buildPostActivityButtons();
			} else {
				$('.embedMedia:last').one("load", function (_this) {
					return function () {
						_this.buildPostActivityButtons();
						_this.HandleResizeEvent();
					};
				}(this));
			}
			$('#head').attr('tabindex', '1').css('outline', 'none');
			$('#head').focus();
			
			this.scrollViewToTop();

		};
		/**
		 *
		 * Adds the button(s) for the post activity into the app container.
		 *
		 * @method buildPostActivityButtons
		 *
		 */
		GraphicSelectApp.prototype.buildPostActivityButtons = function () {
			var GS_buttonSet;
			GS_buttonSet = document.createElement('div');
			GS_buttonSet.id = 'GS_buttonSet';
			this._appContainer.appendChild(GS_buttonSet);
			GS_buttonSet.appendChild(this._restartButton);
		};
		/**
		 *
		 * Builds the current activity and adds it to the app container.
		 *
		 * @method buildActivity
		 *
		 */
		GraphicSelectApp.prototype.buildActivity = function () {
			//this.scrollViewToTop();
			//console.log ('buildActivity scrollViewToTop')

			var GS_instructions, hasImage, i, j, temp, iText;
			hasImage = false;
			if (this._appData.QuestionDisplay === 'all' && this._continuousFeedback === true && this._endReport === false) {
				i = 0;
				while (i < this.Questions.length) {
					this._submitCheck.push(false);
					i++;
				}
				this._submitInterval = setInterval(this.CheckAllSubmits, 250);
			}
			this._tabIndex = 2;
			GS_instructions = document.createElement('p');
			GS_instructions.id = 'GS_instructions';
			if (this._appData.QuestionDisplay === 'single') {
				if (this._continuousFeedback === false && this._reportFeedback === false && this._endReport === true) {
					iText = this._appData.Instructions + '<br><br>' + " <span class=\"GS_instruct_common\">" + this._appData.Instruct_common + " " + this._appData.Instruct_01 + " " + this._appData.Instructions_KeyUserText + "</span>";
				} else {
					iText = this._appData.Instructions + '<br><br>' + " <span class=\"GS_instruct_common\">" + this._appData.Instruct_common + " " + this._appData.Instruct_02 + " " + this._appData.Instructions_KeyUserText + "</span>";
				}
			} else if (this._appData.QuestionDisplay === 'all') {
				if (this._continuousFeedback === true && this._endReport === false) {
					iText = this._appData.Instructions + '<br><br>' + " <span class=\"GS_instruct_common\">" + this._appData.Instruct_common + " " + this._appData.Instruct_03 + " " + this._appData.Instructions_KeyUserText + "</span>";
				} else {
					iText = this._appData.Instructions + '<br><br>' + " <span class=\"GS_instruct_common\">" + this._appData.Instruct_common + " " + this._appData.Instruct_04 + " " + this._appData.Instructions_KeyUserText + "</span>";
				}
			}
			GS_instructions.innerHTML = iText;
			$(GS_instructions).hide().appendTo(this._appContainer).fadeIn(500);
			//this._appContainer.appendChild(GS_instructions);
			var GS_iToggle = document.createElement('span');
			GS_iToggle.id = 'GS_iToggle'
			GS_iToggle.setAttribute('tabindex', '1');
			$(GS_iToggle).addClass('iDown');
			GS_iToggle.innerHTML = '&#9650;<span class="sr-only">Collapse instructions</span>';
			$(GS_iToggle).click(function () {
				if ($(this).hasClass('iDown') === true) {
					$(this).removeClass('iDown');
					$(this).addClass('iUp');
					$("#GS_instructions").slideUp(500);
					this.innerHTML = '&#9660;<span class="sr-only">Collapse instructions</span>';
				} else {
					$(this).addClass('iDown');
					$(this).removeClass('iUp');
					$("#GS_instructions").slideDown(500);
					this.innerHTML = '&#9650;<span class="sr-only">Collapse instructions</span>';
				}
			});
			$(GS_iToggle).keyup(function (event) {
				if (event.keyCode === 13) {
					$(this).click();
				}
			});
			$(GS_iToggle).hide().appendTo(this._appContainer).fadeIn(500);
			// this.buildInstructions();
			this.buildTable();
			this.addQuestions();
			j = 0;
			while (j < this._appData.Answers.length) {
				temp = document.getElementById('head' + j);
				if ($(temp.firstChild).hasClass('tableHeadImage')) {
					hasImage = true;
				}
				j++;
			}
			if (hasImage === true) {
				$('.tableHeadImage:last').one("load", function (_this) {
					return function () {
						_this.buildActivityButtons();
					};
				}(this));
			} else if (hasImage === false) {
				this.buildActivityButtons();
			}
			$('#head').attr('tabindex', '1').css('outline', 'none');
			$('#head').focus();
		};
		/**
		 *
		 * Adds the button(s) for the current activity into the app container.
		 *
		 * @method buildActivityButtons
		 *
		 */
		GraphicSelectApp.prototype.buildActivityButtons = function () {
			var GS_buttonSet;
			GS_buttonSet = document.createElement('div');
			GS_buttonSet.id = 'GS_buttonSet';
			$(GS_buttonSet).hide().appendTo(this._appContainer).fadeIn(500);
			// this._appContainer.appendChild(GS_buttonSet);
			if (this._appData.AllowPrevious === true && this._appData.QuestionDisplay === 'single') {
				if (this._pageNum > 0) {
					GS_buttonSet.appendChild(this._backButton);
				}
			}
			if (this._appData.QuestionDisplay === 'all' && this._appData.SubmitAll === true) {
				GS_buttonSet.appendChild(this._submitAllButton);
			}
			GS_buttonSet.appendChild(this._nextButton);
			if (this._appData.QuestionDisplay === 'single') {
				if (this._continuousFeedback === false && this._reportFeedback === false && this._endReport === true) {
					document.getElementById('GS_nextButton').disabled = false;
				} else {
					document.getElementById('GS_nextButton').disabled = true;
					$('#GS_nextButton').hide();
				}
			} else if (this._appData.QuestionDisplay === 'all' && this._continuousFeedback === true && this._endReport === false) {
				document.getElementById('GS_nextButton').disabled = true;
				$('#GS_nextButton').hide();
			}
			if (this._appData.QuestionDisplay === 'single') {
				if (this._currentQuestion < this.Questions.length - 1) {
					document.getElementById('GS_nextButton').lastChild.innerHTML = 'Next Question';
				} else {
					if (this._noPost === true && this._endReport === false) {
						document.getElementById('GS_nextButton').lastChild.innerHTML = 'Restart Activity';
					} else {
						document.getElementById('GS_nextButton').lastChild.innerHTML = 'Continue';
					}
				}
			} else if (this._appData.QuestionDisplay === 'all') {
				if (this._noPost === true && this._endReport === false) {
					document.getElementById('GS_nextButton').lastChild.innerHTML = 'Restart Activity';
				} else {
					document.getElementById('GS_nextButton').lastChild.innerHTML = 'Continue';
				}
			}
			this.HandleResizeEvent();
		};
		/**
		 *
		 * Changes whether the instructions text is visible or not.
		 *
		 * @method toggleInstructions
		 *
		 */
		GraphicSelectApp.prototype.toggleInstructions = function () {
			$('#GS_instructionsToggle').toggle();
			$('#GS_instructionsToggle').focus();
			$('#GS_instructionsToggle').attr('role', 'alert');
			$('#GS_instructionsToggle').attr('aria-live', 'assertive');
			this.HandleResizeEvent();
		};
		/**
		 *
		 * Builds the correct instructions based on the type of activity and the type of feedback. This is because depending on
		 * the setup certain buttons/elements may or may not be present.
		 *
		 * @method buildInstructions
		 *
		 */
		GraphicSelectApp.prototype.buildInstructions = function () {
			var GS_instructionButtonSet, GS_instructionText, GS_instructions;
			GS_instructionButtonSet = document.createElement('div');
			GS_instructionButtonSet.id = 'GS_instructionButtonSet';
			this._appContainer.appendChild(GS_instructionButtonSet);
			this._instructionButton.setAttribute('tabindex', this._tabIndex);
			this._tabIndex++;
			GS_instructionButtonSet.appendChild(this._instructionButton);
			GS_instructions = document.createElement('div');
			GS_instructions.id = 'GS_instructionsToggle';
			GS_instructions.setAttribute('class', 'toggledOff');
			GS_instructionText = document.createElement('p');
			GS_instructionText.id = 'GS_instructionText';
			GS_instructionText.setAttribute('class', 'tooltip');
			if (this._appData.QuestionDisplay === 'single') {
				if (this._continuousFeedback === false && this._reportFeedback === false && this._endReport === true) {
					GS_instructionText.innerHTML = this._appData.Instruct_common + " " + this._appData.Instruct_01 + " <br><br> " + this._appData.Instructions_KeyUserText;
				} else {
					GS_instructionText.innerHTML = this._appData.Instruct_common + " " + this._appData.Instruct_02 + " <br><br> " + this._appData.Instructions_KeyUserText;
				}
			} else if (this._appData.QuestionDisplay === 'all') {
				if (this._continuousFeedback === true && this._endReport === false) {
					GS_instructionText.innerHTML = this._appData.Instruct_common + " " + this._appData.Instruct_03 + " <br><br> " + this._appData.Instructions_KeyUserText;
				} else {
					GS_instructionText.innerHTML = this._appData.Instruct_common + " " + this._appData.Instruct_04 + " <br><br> " + this._appData.Instructions_KeyUserText;
				}
			}
			GS_instructions.appendChild(GS_instructionText);
			$(GS_instructions).insertBefore('#GS_instructionButtonSet');
			$('#GS_instructionsToggle').toggle();
		};
		/**
		 *
		 * Builds the table for the activity. It also adds the questions and table name into the first row of the table.
		 *
		 * @method buildTable
		 *
		 */
		GraphicSelectApp.prototype.buildTable = function () {
			var GS_tHead, GS_tHeading, GS_tResults, GS_tRow, GS_table, GS_tableContainer, i, tempImg, tempTD, tempText;
			GS_tableContainer = document.createElement('div');
			tempTD = void 0;
			GS_tableContainer.id = 'GS_tableContainer';
			GS_table = document.createElement('table');
			GS_table.id = 'GS_table';
			GS_tHead = document.createElement('thead');
			GS_tHead.id = 'GS_tHead';
			GS_tRow = document.createElement('tr');
			GS_tRow.setAttribute('class', 'GS_tRow');
			GS_tHeading = document.createElement('th');
			GS_tHeading.id = 'GS_tHeading';
			$(GS_tHeading).addClass('bg-table');
			GS_tHeading.innerHTML = '<p>' + this._appData.TableHeading + '</p>';
			GS_tHeading.setAttribute('scope', 'col');
			if (this._usingIE === true) {
				GS_tHeading.setAttribute('title', this._appData.TableHeading);
			}
			GS_tHeading.setAttribute('tabindex', this._tabIndex);
			this._tabIndex++;
			GS_tRow.appendChild(GS_tHeading);
			i = 0;
			while (i < this._appData.Answers.length) {
				tempTD = document.createElement('th');
				tempTD.id = 'head' + i;
				tempTD.setAttribute('class', 'GS_tAnswer');
				tempTD.setAttribute('scope', 'col');
				if (this._usingIE === true) {
					tempTD.title = this._appData.Answers[i].text;
				}
				tempTD.setAttribute('tabindex', this._tabIndex);
				this._tabIndex++;
				if (this._appData.Answers[i].imgSrc !== 'none' && this._appData.Answers[i].imgSrc !== null && this._appData.Answers[i].imgSrc !== void 0 && this._appData.Answers[i].imgSrc !== '') {
					tempImg = document.createElement('img');
					tempImg.src = this._appData.Answers[i].imgSrc;
					tempImg.alt = this._appData.Answers[i].alt;
					tempImg.setAttribute('class', 'tableHeadImage');
					tempTD.appendChild(tempImg);
				}
				tempText = document.createElement('p');
				tempText.innerHTML = this._appData.Answers[i].text;
				tempTD.appendChild(tempText);
				GS_tRow.appendChild(tempTD);
				i++;
			}
			GS_tResults = document.createElement('th');
			GS_tResults.id = 'GS_tResults';
			GS_tResults.setAttribute('scope', 'col');
			GS_tResults.setAttribute('tabindex', this._tabIndex);
			this._tabIndex++;
			GS_tRow.appendChild(GS_tResults);
			GS_tHead.appendChild(GS_tRow);
			GS_table.appendChild(GS_tHead);
			//
			$(".gs_tResults").click(function () {
				$(".ansInfo").removeClass("hide");
			}); //
			//Add custom instructions modal here
			/* GS_tResults.innerHTML = '<img style="height:100px" class="revealInfo" src="http://www.clker.com/cliparts/5/f/9/7/11971487051948962354zeratul_Help.svg.med.png"><div class="ansInfo"><p>hello</p></div>'; */
			GS_tableContainer.appendChild(GS_table);
			$(GS_tableContainer).hide().appendTo(this._appContainer).fadeIn(500);
			//this._appContainer.appendChild(GS_tableContainer);
		};
		/**
		 *
		 * Depending on the how the activity was configured, it adds the appropriate number if question(s) to the table, the checkboxes
		 * and the buttons associated with each question.
		 *
		 * @method addQuestions
		 *
		 */
		GraphicSelectApp.prototype.addQuestions = function () {
			var GS_resetButton, GS_resetLabel, GS_submitButton, GS_submitLabel, GS_tBody, GS_table, i, j, tempInput, tempQuestion, tempQuestionCont, tempResults, tempRow, tempTD, tempTitle;
			tempTD = void 0;
			tempRow = void 0;
			tempTitle = void 0;
			tempInput = void 0;
			tempQuestionCont = void 0;
			tempQuestion = void 0;
			tempResults = void 0;
			GS_tBody = void 0;
			GS_submitButton = void 0;
			GS_submitLabel = void 0;
			GS_resetButton = void 0;
			GS_resetLabel = void 0;
			j = void 0;
			GS_tBody = document.createElement('tbody');
			GS_tBody.id = 'GS_tBody';
			GS_table = $('#GS_table')[0];
			if (this._appData.QuestionDisplay === 'all') {
				i = 0;
				while (i < this.Questions.length) {
					tempRow = document.createElement('tr');
					tempRow.id = 'row' + i;
					tempRow.setAttribute('class', 'GS_tRow');
					tempQuestionCont = document.createElement('th');
					tempQuestionCont.id = 'question' + i;
					tempQuestionCont.setAttribute('class', 'GS_tQuestion');
					tempQuestionCont.setAttribute('scope', 'row');
					if (this._usingIE === true) {
						if (this._appData.NumberedQuestions === true) {
							tempQuestionCont.setAttribute('title', i + 1 + '. ' + this.Questions[i].text);
						} else {
							tempQuestionCont.setAttribute('title', this.Questions[i].text);
						}
					}
					tempQuestionCont.setAttribute('tabindex', this._tabIndex);
					this._tabIndex++;
					if (i === this.Questions.length - 1) {
						$(tempQuestionCont).addClass('last');
					}
					tempQuestion = document.createElement('p');
					if (this._appData.NumberedQuestions === true) {
						tempQuestion.innerHTML = i + 1 + '. ' + this.Questions[i].text;
					} else {
						tempQuestion.innerHTML = this.Questions[i].text;
					}
					tempQuestionCont.appendChild(tempQuestion);
					tempRow.appendChild(tempQuestionCont);
					j = 0;
					while (j < this._appData.Answers.length) {
						tempTD = document.createElement('td');
						tempTD.id = 'GS_tCheck' + i + j;
						tempTD.setAttribute('class', 'GS_tCheckBox');
						if (i === this.Questions.length - 1) {
							$(tempTD).addClass('last');
						}
						
						tempTitle = document.createElement('p');
						tempTitle.setAttribute('class', 'GS_feedback');
//						tempTitle.innerHTML = 'Your Answer:';
						tempTitle.innerHTML = '<span class="sr-only">Your Answer:</span>';
						tempInput = document.createElement('div');
						tempInput.id = 'checkbox' + i + j;
						tempInput.setAttribute('class', 'GS_tInput check');
						tempInput.setAttribute('role', 'checkbox');
						tempInput.setAttribute('aria-checked', 'false');
						tempInput.setAttribute('tabindex', this._tabIndex);
						this._tabIndex++;
						tempInput.onclick = (function (_this) {
							return function (e) {
								_this.HandleSelection(e);
								if ($('#GS_iToggle').hasClass('iDown') === true) {
									$('#GS_iToggle').click();
								}
							};
						})(this);
						tempInput.onkeydown = (function (_this) {
							return function (e) {
								if (e.which === 13 || e.which === 32) {
									_this.HandleSelection(e);
									if ($('#GS_iToggle').hasClass('iDown') === true) {
										$('#GS_iToggle').click();
									}
								}
							};
						})(this);
						tempTD.appendChild(tempTitle);
						tempTD.appendChild(tempInput);
						tempRow.appendChild(tempTD);
						j++;
					}
					tempResults = document.createElement('td');
					tempResults.id = 'results' + i;
					tempResults.setAttribute('class', 'GS_tQuestionResults');
					if (i === this.Questions.length - 1) {
						$(tempResults).addClass('last');
					}
					if (this._continuousFeedback === true) {
						GS_submitButton = document.createElement('button');
						GS_submitButton.id = 'GS_submitButton' + i;
						GS_submitButton.setAttribute('class', 'GS_resultButton');
						GS_submitButton.setAttribute('title', 'Submits your answer');
						GS_submitButton.setAttribute('tabindex', this._tabIndex);
						this._tabIndex++;
						GS_submitButton.onclick = function () {
							var appRef, numRef;
							appRef = window.application;
							appRef.CheckAnswer(this, 'submit');
							numRef = this.id.substr(15);
							appRef._submitCheck.splice(numRef, 1, true);
						};
						GS_submitLabel = document.createElement('span');
						GS_submitLabel.setAttribute('class', 'GS_buttonLabel');
						GS_submitLabel.innerHTML = 'Submit';
						GS_submitButton.appendChild(GS_submitLabel);
						tempResults.appendChild(GS_submitButton);
					}
					GS_resetButton = document.createElement('button');
					GS_resetButton.id = 'GS_resetButton' + i;
					GS_resetButton.setAttribute('class', 'GS_resultButton');
					GS_resetButton.setAttribute('title', 'Resets your answer');
					GS_resetButton.setAttribute('tabindex', this._tabIndex);
					this._tabIndex += 2;
					GS_resetButton.onclick = function () {
						var appRef, numRef;
						appRef = window.application;
						appRef.ResetQuestionAnswers(this);
						numRef = this.id.substr(14);
						appRef._submitCheck.splice(numRef, 1, false);
					};
					GS_resetLabel = document.createElement('span');
					GS_resetLabel.setAttribute('class', 'GS_buttonLabel');
					GS_resetLabel.innerHTML = 'Reset Answers';
					GS_resetButton.appendChild(GS_resetLabel);
					tempResults.appendChild(GS_resetButton);
					tempRow.appendChild(tempResults);
					GS_tBody.appendChild(tempRow);
					GS_table.appendChild(GS_tBody);
					i++;
				}
			} else if (this._appData.QuestionDisplay === 'single') {
				tempRow = document.createElement('tr');
				tempRow.id = 'row' + this._currentQuestion;
				tempRow.setAttribute('class', 'GS_tRow');
				tempQuestionCont = document.createElement('th');
				tempQuestionCont.id = 'question' + this._currentQuestion;
				tempQuestionCont.setAttribute('class', 'GS_tQuestion');
				tempQuestionCont.setAttribute('scope', 'row');
				tempQuestionCont.setAttribute('tabindex', this._tabIndex);
				this._tabIndex++;
				$(tempQuestionCont).addClass('last');
				tempQuestion = document.createElement('p');
				tempQuestion.innerHTML = this._currentQuestion + 1 + '. ' + this.Questions[this._currentQuestion].text;
				tempQuestionCont.appendChild(tempQuestion);
				tempRow.appendChild(tempQuestionCont);
				j = 0;
				while (j < this._appData.Answers.length) {
					tempTD = document.createElement('td');
					tempTD.id = 'GS_tCheck' + this._currentQuestion + j;
					tempTD.setAttribute('class', 'GS_tCheckBox');
					$(tempTD).addClass('last');
					tempTitle = document.createElement('p');
					tempTitle.setAttribute('class', 'GS_feedback');
					tempTitle.innerHTML = '';
					tempInput = document.createElement('div');
					tempInput.id = 'checkbox' + this._currentQuestion + j;
					tempInput.setAttribute('class', 'GS_tInput check');
					tempInput.setAttribute('role', 'checkbox');
					tempInput.setAttribute('aria-checked', 'false');
					tempInput.setAttribute('tabindex', this._tabIndex);
					tempInput.setAttribute('onclick', 'window.application.HandleSelection(event)');
					tempInput.setAttribute('onkeydown', 'window.application.HandleKeyboardSelection(event)');
					if (this._allCheck[this._currentQuestion][j] === true) {
						$(tempInput).addClass('selected');
					}
					this._tabIndex++;
					tempTD.appendChild(tempTitle);
					tempTD.appendChild(tempInput);
					tempRow.appendChild(tempTD);
					j++;
				}
				tempResults = document.createElement('td');
				tempResults.id = 'results' + this._currentQuestion;
				tempResults.setAttribute('class', 'GS_tQuestionResults');
				$(tempResults).addClass('last');
				if (this._continuousFeedback === true || this._reportFeedback === true) {
					GS_submitButton = document.createElement('button');
					GS_submitButton.id = 'GS_submitButton' + this._currentQuestion;
					GS_submitButton.setAttribute('class', 'GS_resultButton');
					GS_submitButton.setAttribute('title', 'Submits your answer');
					GS_submitButton.setAttribute('tabindex', this._tabIndex);
					this._tabIndex++;
					GS_submitButton.onclick = function () {
						var appRef;
						appRef = window.application;
						appRef.CheckAnswer(this, 'submit');
						if (appRef._reportFeedback === true) {
							if ($('#GS_report' + this.id.substr(15)).length) {
								$('#GS_report' + this.id.substr(15)).remove();
							}
							appRef.BuildMiniReport(this.id.substr(15));
						}
						document.getElementById('GS_nextButton').disabled = false;
						$('#GS_nextButton').fadeIn(500);
					};
					GS_submitLabel = document.createElement('span');
					GS_submitLabel.setAttribute('class', 'GS_buttonLabel');
					GS_submitLabel.innerHTML = 'Submit';
					GS_submitButton.appendChild(GS_submitLabel);
					tempResults.appendChild(GS_submitButton);
				}
				GS_resetButton = document.createElement('button');
				GS_resetButton.id = 'GS_resetButton' + this._currentQuestion;
				GS_resetButton.setAttribute('class', 'GS_resultButton');
				GS_resetButton.setAttribute('title', 'Resets your answer');
				GS_resetButton.setAttribute('tabindex', this._tabIndex);
				this._tabIndex += 2;
				GS_resetButton.onclick = function () {
					var appRef;
					appRef = window.application;
					appRef.ResetQuestionAnswers(this);
					if (appRef._reportFeedback === true) {
						if ($('#GS_report' + this.id.substr(14)).length) {
							$('#GS_report' + this.id.substr(14)).remove();
						}
					}
					if (appRef._appData.QuestionDisplay === 'single') {
						if (appRef._continuousFeedback === false && appRef._reportFeedback === false && appRef._endReport === true) {
							document.getElementById('GS_nextButton').disabled = false;
							$('#GS_nextButton').fadeIn(500);
						} else {
							document.getElementById('GS_nextButton').disabled = true;
							$('#GS_nextButton').fadeOut(500);
						}
					}
					appRef.HandleResizeEvent();
				};
				GS_resetLabel = document.createElement('span');
				GS_resetLabel.setAttribute('class', 'GS_buttonLabel');
				GS_resetLabel.innerHTML = 'Reset Answers';
				GS_resetButton.appendChild(GS_resetLabel);
				tempResults.appendChild(GS_resetButton);
				tempRow.appendChild(tempResults);
				GS_tBody.appendChild(tempRow);
				GS_table.appendChild(GS_tBody);
			}
		};
		/**
		 *
		 * Depending on the checkbox you clicked on, it determines whether it should be checked/unchecked, and adjusts it accordingly.
		 *
		 * @method HandleSelection
		 *
		 * @param {event} e
		 *
		 */
		GraphicSelectApp.prototype.HandleSelection = function (e) {
			var selectedBox;
			selectedBox = e.target;
			if ($(selectedBox).hasClass('check')) {
				if ($(selectedBox).hasClass('selected')) {
					$(selectedBox).removeClass('selected');
					selectedBox.setAttribute('aria-checked', 'false');
				} else {
					$(selectedBox).addClass('selected');
					selectedBox.setAttribute('aria-checked', 'true');
				}
			}
		};
		/**
		 *
		 * Takes a keyboard event performed on a checkbox, and determines if it was an enter or spacebar.
		 * If so, it handles the selection accordingly.
		 *
		 * @method HandleKeyboardSelection
		 *
		 * @param {event} e
		 *
		 */
		GraphicSelectApp.prototype.HandleKeyboardSelection = function (e) {
			if (e.which === 13 || e.which === 32) {
				this.HandleSelection(e);
			}
		};
		/**
		 *
		 * Depending on the button that made the call, it saves the users answers accordingly.
		 *
		 * @method CheckAnswer
		 *
		 * @param {Object} target
		 * @param {String} button, type of button that made call
		 *
		 */
		GraphicSelectApp.prototype.CheckAnswer = function (target, button) {
			var i, id, idNum, temp;
			id = void 0;
			idNum = void 0;
			if (button === 'next') {
				idNum = target;
			} else if (button === 'submit') {
				id = target.id;
				idNum = id.substr(15);
			} else if (button === 'submitAll') {
				idNum = target;
				document.getElementById('GS_nextButton').disabled = false;
				$('#GS_nextButton').fadeIn(500);
			}
			i = 0;
			while (i < this._appData.Answers.length) {
				temp = document.getElementById('checkbox' + idNum + i);
				if ($(temp).hasClass('selected') === true) {
					this._allCheck[idNum].splice(i, 1, true);
				} else {
					this._allCheck[idNum].splice(i, 1, false);
				}
				i++;
			}
			if (button === 'submit' || button === 'submitAll') {
				// if (this._continuousFeedback === true) {
				this.GenerateQuestionFeedback(idNum);
				// }
			}
		};
		/**
		 *
		 * Resets all the checkboxes to an unchecked state.
		 *
		 * @method ResetQuestionAnswers
		 *
		 * @param {Object} target
		 *
		 */
		GraphicSelectApp.prototype.ResetQuestionAnswers = function (target) {
			var i, id, idNum, tempBox;
			id = target.id;
			idNum = id.substr(14);
			i = 0;
			while (i < this._appData.Answers.length) {
				if ($(document.getElementById('GS_tCheck' + idNum + i).lastChild).hasClass('GS_corrAnsImg') === true) {
					$(document.getElementById('GS_tCheck' + idNum + i).lastChild).remove();
				}
				if ($(document.getElementById('GS_tCheck' + idNum + i).lastChild).hasClass('GS_feedback') === true) {
					$(document.getElementById('GS_tCheck' + idNum + i).lastChild).remove();
				}
				tempBox = document.getElementById('GS_tCheck' + idNum + i).lastChild;
				tempBox.removeAttribute('title');
				tempBox.setAttribute('class', 'GS_tInput check');
				tempBox.setAttribute('role', 'checkbox');
				tempBox.setAttribute('aria-checked', 'false');
				tempBox.setAttribute('onclick', 'application.HandleSelection(event)');
				tempBox.setAttribute('onkeydown', 'application.HandleKeyboardSelection(event)');
				$('.GS_tInput').css('cursor', 'pointer');
				i++;
			}
			if ($(document.getElementById('results' + idNum).lastChild).hasClass('GS_feedback') === true) {
				$(document.getElementById('GS_qFeedback' + idNum)).remove();
			}
			if (document.getElementById('GS_submitButton' + idNum)) {
				document.getElementById('GS_submitButton' + idNum).disabled = false;
				$('#GS_submitButton' + idNum).fadeIn(500);
			}
		};
		/**
		 *
		 * Takes the question number and builds continuous feedback for that question based on the user's answers.
		 *
		 * @method GenerateQuestionFeedback
		 *
		 * @param {Integer} qNum
		 *
		 */
		GraphicSelectApp.prototype.GenerateQuestionFeedback = function (qNum) {
			var box, contFeed, corrAns, i, questionScore, resultCont, tabRef, tempTitle;
			tempTitle = void 0;
			corrAns = void 0;
			questionScore = 0;
			resultCont = document.getElementById('results' + qNum);
			document.getElementById('GS_submitButton' + qNum).disabled = true;
			$('#GS_submitButton' + qNum).fadeOut(500);
			$('#GS_resetButton' + qNum).focus();
			i = 0;
			while (i < this._appData.Answers.length) {
				box = document.getElementById('GS_tCheck' + qNum + i).lastChild;
				if (this._allCheck[qNum][i] === this._allCorrect[qNum][i]) {
					questionScore++;
					box.setAttribute('class', 'GS_tInput');
					if (this._allCheck[qNum][i] === true) {
						$(box).addClass('selected');
						box.setAttribute('title', 'Selected checkbox graphic.');
					} else {
						box.setAttribute('title', 'Unselected checkbox graphic.');
					}
					box.removeAttribute('role');
					box.removeAttribute('aria-checked');
					box.removeAttribute('onclick');
					box.removeAttribute('onkeydown');
					$('.GS_tInput').css('cursor', 'default');
					$(box).addClass('disabled');
					tempTitle = document.createElement('p');
					tempTitle.setAttribute('class', 'GS_feedback');
					tempTitle.innerHTML = ''; //Correct Answer:
					document.getElementById('GS_tCheck' + qNum + i).appendChild(tempTitle);
					corrAns = document.createElement('img');
					corrAns.setAttribute('class', 'GS_corrAnsImg');
					if (this._allCorrect[qNum][i] === true) {
						corrAns.src = 'img/correct-ans-chk.png'; //'http://portal.farmcentric.com/images/arrow-up-large.png';
						corrAns.alt = 'This checkbox should be selected.';
						document.getElementById('GS_tCheck' + qNum + i).appendChild(corrAns);
					} else {
						corrAns.src = 'img/correct-ans-unchk.png'; //img/icon-unchecked-24.png
						corrAns.alt = 'This checkbox should not be selected.';
						document.getElementById('GS_tCheck' + qNum + i).appendChild(corrAns);
					}
				} else {
					box.setAttribute('class', 'GS_tInput');
					if (this._allCheck[qNum][i] === true) {
						$(box).addClass('selected');
						box.setAttribute('title', 'Selected checkbox graphic.');
					} else {
						box.setAttribute('title', 'Unselected checkbox graphic.');
					}
					box.removeAttribute('role');
					box.removeAttribute('aria-checked');
					box.removeAttribute('onclick');
					box.removeAttribute('onkeydown');
					$('.GS_tInput').css('cursor', 'default');
					$(box).addClass('disabled');
					tempTitle = document.createElement('p');
					tempTitle.setAttribute('class', 'GS_feedback');
					tempTitle.innerHTML = ''; //Correct Answer:
					document.getElementById('GS_tCheck' + qNum + i).appendChild(tempTitle);
					corrAns = document.createElement('img');
					corrAns.setAttribute('class', 'GS_corrAnsImg');
					if (this._allCorrect[qNum][i] === true) {
						corrAns.src = 'img/correct-ans-chk.png'; //'img/icon-checked-24.png';
						corrAns.alt = 'This checkbox should be selected.';
						document.getElementById('GS_tCheck' + qNum + i).appendChild(corrAns);
					} else {
						corrAns.src = 'img/correct-ans-chk-wrong.png'; //'img/icon-unchecked-24.png';
						corrAns.alt = 'This checkbox should not be selected.';
						document.getElementById('GS_tCheck' + qNum + i).appendChild(corrAns);
					}
				}
				i++;
			}
			if ($(resultCont.lastChild).hasClass('GS_feedback') === true) {
				$(document.getElementById('GS_qFeedback' + qNum)).remove();
			}
			tabRef = document.getElementById('GS_resetButton' + qNum);
		};
		/**
		 *
		 * Takes the question number and builds a report for that question based on the user's answers.
		 *
		 * @method BuildMiniReport
		 *
		 * @param {Integer} qNum
		 *
		 */
		GraphicSelectApp.prototype.BuildMiniReport = function (qNum) {
			var GS_ResponseText, GS_questionHead, GS_report, RespCntx, RespImg, maxScore, qScore;
			GS_questionHead = void 0;
			GS_report = document.createElement('div');
			GS_report.id = 'GS_report' + qNum;
			GS_report.setAttribute('class', 'GS_report');
			if (this._finalReport === true) {
				GS_questionHead = document.createElement("h" + (this._headingLevel + 1));
				GS_questionHead.setAttribute('class', 'GS_questionHead');
				GS_questionHead.innerHTML = 'Question: ' + this.Questions[qNum].text;
			}
			GS_ResponseText = document.createElement("h" + (this._headingLevel + 2));
			GS_ResponseText.setAttribute('class', 'GS_responseText');
			RespImg = document.createElement('img');
			RespImg.setAttribute('class', 'GS_responseGraphic');
			RespCntx = document.createElement('strong');
			qScore = this.GetQuestionScore(qNum);
			maxScore = this.GetQuestionTotal(qNum); //this._appData.Answers.length;
			if (qScore >= maxScore) {
				RespImg.setAttribute('src', '../../_assets/iats/multiselect/img/icon-right-24.png');
				RespImg.setAttribute('alt', 'Right Answer Graphic.');
				RespCntx.innerHTML = 'Your answer was correct.';
			} else if (qScore <= 0) {
				RespImg.setAttribute('src', '../../_assets/iats/multiselect/img/icon-wrong-24.png');
				RespImg.setAttribute('alt', 'Incorrect Answer Graphic.');
				RespCntx.innerHTML = 'Your answer was incorrect.';
			} else {
				RespImg.setAttribute('src', '../../_assets/iats/multiselect/img/icon-partial-24.png');
				RespImg.setAttribute('alt', 'Partially Correct Answer Graphic');
				RespCntx.innerHTML = 'Your answer was partially correct.';
			}
			GS_ResponseText.appendChild(RespImg);
			GS_ResponseText.appendChild(RespCntx);
			if (this._finalReport === true) {
				GS_report.appendChild(GS_questionHead);
			}
			GS_report.appendChild(GS_ResponseText);
			if (this._finalReport === true) {
				$(GS_report).hide().appendTo(this._appContainer).fadeIn(500);
				this._appContainer.appendChild(GS_report);
			} else {
				$(GS_report).hide().insertAfter($('#GS_tableContainer')).fadeIn(500);
			}
			// if (qScore < maxScore) {
			this.BuildResultTable(qNum);
			// }
			this.BuildFeedback(qNum, GS_report);
			this.HandleResizeEvent();
		};
		/**
		 *
		 * Takes the question number and calculates the number of correct answers for that question.
		 *
		 * @method GetQuestionScore
		 *
		 * @param {Integer} qNum, question number
		 *
		 * @return {Interger} Returns number of correct answers for that question.
		 *
		 */
		GraphicSelectApp.prototype.GetQuestionScore = function (qNum) {
			var i, score, foundWrong;
			score = 0;
			foundWrong = false;
			i = 0;
			while (i < this._appData.Answers.length) {
				if (this._allCheck[qNum][i] === true && this._allCorrect[qNum][i] === true) {
					score++;
				} else if (this._allCheck[qNum][i] === true && this._allCorrect[qNum][i] === false) {
					if (foundWrong === false) {
						foundWrong = true;
						score -= 0.1;
					}
				}
				i++;
			}
			return score;
		};
		/**
		 *
		 * Takes the question number and calculates the number of correct answers for that question.
		 *
		 * @method GetQuestionTotal
		 *
		 * @param {Integer} qNum, question number
		 *
		 * @return {Interger} Returns number of correct answers for that question.
		 *
		 */
		GraphicSelectApp.prototype.GetQuestionTotal = function (qNum) {
			var i, total;
			total = 0;
			i = 0;
			while (i < this._appData.Answers.length) {
				if (this._allCorrect[qNum][i] === true) {
					total++;
				}
				i++;
			}
			return total;
		};
		/**
		 *
		 * Takes the question number and builds a table comparing the user's answers for that question to the correct answers.
		 *
		 * @method BuildResultTable
		 *
		 * @param {Integer} qNum, question number
		 *
		 */
		GraphicSelectApp.prototype.BuildResultTable = function (qNum) {
			var body, checked, checkedBox, correct, correctAnswers, feedback, head, i, location, right, row, table, tableCont, uncheckedBox, user, userAnswers, wrong;
			location = document.getElementById('GS_report' + qNum);
			tableCont = document.createElement('div');
			tableCont.id = 'GS_resultTableContainer' + qNum;
			table = document.createElement('table');
			table.id = 'GS_resultTable' + qNum;
			table.setAttribute('class', 'GS_resultTable');
			head = document.createElement('thead');
			head.id = 'GS_resultTableHead' + qNum;
			row = document.createElement('tr');
			row.setAttribute('class', 'GS_tRow');
			userAnswers = document.createElement('th');
			userAnswers.id = 'GS_user' + qNum;
			userAnswers.setAttribute('class', 'GS_resultUser');
			userAnswers.setAttribute('scope', 'col');
			userAnswers.setAttribute('style', 'text-align:left;'); //???
			userAnswers.innerHTML = '<strong>You Selected:</strong>';
			row.appendChild(userAnswers);
			/*  correctAnswers = document.createElement('th');
			  correctAnswers.id = 'GS_correct' + qNum;
			  correctAnswers.setAttribute('class', 'GS_resultCorrect');
			  correctAnswers.setAttribute('scope', 'col');
			  correctAnswers.innerHTML = '<strong>Results</stong>';
			  row.appendChild(correctAnswers); */
			head.appendChild(row);
			table.appendChild(head);
			body = document.createElement('tbody');
			body.id = 'GS_resultTableBody' + qNum;
			i = 0;
			while (i < this._appData.Answers.length) {
				if (this._allCheck[qNum][i] === true)
					if (this._allCorrect[qNum][i] === true) {
						checkedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-checked.png\' class=\'GS_reportIcon\' alt=\'Checked Box Graphic. This checkbox should be selected.\' />';
						// uncheckedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-unchecked.png\' class=\'GS_reportIcon\' alt=\'Correct Answer, Unchecked Box Graphic\' />';
					} else {
						checkedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-fill.png\' class=\'GS_reportIcon\' alt=\'Checked Box Graphic.\' />';
					} else {
					if (this._allCorrect[qNum][i] === true) {
						uncheckedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-unchecked.png\' class=\'GS_reportIcon\' alt=\'Unchecked Box Graphic. This checkbox should be selected.\' />';
					} else {
						uncheckedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-blank.png\' class=\'GS_reportIcon\' alt=\'Unchecked Box Graphic.\' />';
					}
					// checkedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-fill.png\' class=\'GS_reportIcon\' alt=\'Incorrect Answer, Checked Box Graphic\' />';
					// uncheckedBox = '<img src=\'../../_assets/iats/multiselect/img/ans-blank.png\' class=\'GS_reportIcon\' alt=\'Incorrect Answer, Unchecked Box Graphic\' />';
				}
				right = '<img src=\'../../_assets/iats/multiselect/img/icon-right-24.png\' class=\'GS_reportIcon\' alt=\'Right Answer Graphic\' />';
				wrong = '<img src=\'../../_assets/iats/multiselect/img/icon-wrong-24.png\' class=\'GS_reportIcon\' alt=\'Wrong Answer Graphic\' />';
				checked = void 0;
				feedback = void 0;
				row = document.createElement('tr');
				row.id = 'resultRow' + qNum + i;
				user = document.createElement('td');
				user.id = 'userAnswer' + qNum + i;
				user.setAttribute('class', 'GS_userAnswer');
				if (this._allCheck[qNum][i] === true) {
					checked = checkedBox;
				} else {
					checked = uncheckedBox;
				}
				user.innerHTML = checked + '<p class=\'GS_reportText\'>' + this._appData.Answers[i].text + '</p>';
				if (i === this._appData.Answers.length - 1) {
					$(user).addClass('last');
				}
				/*correct = document.createElement('td');
				correct.id = 'correctAnswer' + qNum + i;
				correct.setAttribute('class', 'GS_correctAnswer');
				if (this._allCheck[qNum][i] === true) {
				   if (this._allCorrect[qNum][i] === true) {
				      feedback = right + '<p class=\'GS_reportText\'>Correct</p>';
				   }
				   else {
				      feedback = wrong + '<p class=\'GS_reportText\'>Incorrect</p>';
				   }
				}
				else {
				   if (this._allCorrect[qNum][i] === true) {
				      feedback = wrong + '<p class=\'GS_reportText\'>Incorrect</p>';
				   }
				   else {
				      feedback = '';
				   }
				}
				correct.innerHTML = feedback;
				if (i === this._appData.Answers.length - 1) {
				   $(correct).addClass('last');
				} */
				row.appendChild(user);
				//row.appendChild(correct);
				body.appendChild(row);
				i++;
			}
			table.appendChild(body);
			tableCont.appendChild(table);
			location.appendChild(tableCont);
		};
		/**
		 *
		 * Based on the question number, it determines if the answer was wrong. If so, it determines if it requires feedback.
		 * If so, it provides said feedback.
		 *
		 * @method BuildFeedback
		 *
		 * @param {Integer} qNum, question number
		 * @param {Object} location
		 *
		 */
		GraphicSelectApp.prototype.BuildFeedback = function (qNum, location) {
			var GS_feedback, GS_feedbackCont, GS_feedbackHead, i, j, noFeedback, option;
			noFeedback = true;
			GS_feedbackCont = document.createElement('div');
			GS_feedbackCont.id = 'GS_feedbackCont' + qNum;
			GS_feedbackCont.setAttribute('class', 'GS_feedbackCont');
			GS_feedbackHead = document.createElement("h" + (this._headingLevel + 2));
			GS_feedbackHead.setAttribute('class', 'GS_feedbackHead');
			GS_feedbackHead.innerHTML = 'Feedback: ';
			GS_feedbackCont.appendChild(GS_feedbackHead);
			if (this._appData.ShowQuestionFeedback === true) {
				if (this.Questions[qNum].questionFeedback !== null && this.Questions[qNum].questionFeedback !== void 0 && this.Questions[qNum].questionFeedback !== 'none' && this.Questions[qNum].questionFeedback !== '') {
					GS_feedback = document.createElement('p');
					GS_feedback.innerHTML = this.Questions[qNum].questionFeedback;
					GS_feedbackCont.appendChild(GS_feedback);
					noFeedback = false;
				}
			}
			i = 0;
			while (i < this.Questions[qNum].answers.length) {
				if (this._allCheck[qNum][i] !== this._allCorrect[qNum][i]) {
					if (this.Questions[qNum].answers[i].feedback !== 'none' && this.Questions[qNum].answers[i].feedback !== null && this.Questions[qNum].answers[i].feedback !== void 0 && this.Questions[qNum].answers[i].feedback !== '') {
						j = 0;
					}
					if (this.Questions[qNum].answers[i].feedback && this.Questions[qNum].answers[i].feedback !== []) {
						while (j < this.Questions[qNum].answers[i].feedback.length) {
							// if (this.Questions[qNum].answers[i].feedback[j].type === 'text') {
							option = document.createElement("h" + (this._headingLevel + 3));
							option.setAttribute('class', 'GS_option');
							option.innerHTML = this._appData.Answers[i].text + ': ';
							GS_feedbackCont.appendChild(option);
							this.EmbedMedia('feedback', GS_feedbackCont, this.Questions[qNum].answers[i].feedback[j]);
							noFeedback = false;
							// }
							j++;
						}
					}
				}
				i++;
			}
			if (noFeedback === false) {
				$(GS_feedbackCont).hide().appendTo(location).slideDown(500, 'swing');
				// location.appendChild(GS_feedbackCont);
			}
		};
		/**
		 *
		 * Builds the end report for the entire quiz.
		 *
		 * @method buildReport
		 *
		 */
		GraphicSelectApp.prototype.buildReport = function () {
			var i;
			i = 0;
			while (i < this.Questions.length) {
				this.BuildMiniReport(i);
				i++;
			}
			this.buildReportButtons();

			this.scrollViewToTop();

		};
		/**
		 *
		 * Adds the button(s) for the end report into the app container.
		 *
		 * @method buildReportButtons
		 *
		 */
		GraphicSelectApp.prototype.buildReportButtons = function () {
			var GS_buttonSet;
			GS_buttonSet = document.createElement('div');
			GS_buttonSet.id = 'GS_buttonSet';
			this._appContainer.appendChild(GS_buttonSet);
			GS_buttonSet.appendChild(this._nextButton);
			if (this._noPost === true) {
				document.getElementById('GS_nextButton').lastChild.innerHTML = 'Restart Activity';
			} else {
				document.getElementById('GS_nextButton').lastChild.innerHTML = 'Continue';
			}
		};
		/**
		 *
		 * Checks if all of the submit buttons on the page have been pressed or not and determines whether the next button should be disabled.
		 *
		 * @method CheckAllSubmits
		 *
		 */
		GraphicSelectApp.prototype.CheckAllSubmits = function () {
			var i, unsubmitted;
			unsubmitted = 0;
			i = 0;
			while (i < this._submitCheck.length) {
				if (this._submitCheck[i] === false) {
					unsubmitted++;
				}
				i++;
			}
			if (unsubmitted === 0) {
				document.getElementById('GS_nextButton').disabled = false;
				$('#GS_nextButton').fadeIn(500);
			} else {
				document.getElementById('GS_nextButton').disabled = true;
				$('#GS_nextButton').fadeOut(500);
			}
		};
		/**
		 *
		 * Takes the passed object data and embeds it according to it's type and whether it's feedback or pre/post activity content.
		 *
		 * @method EmbedMedia
		 *
		 * @param {String} type
		 * @param {String} containerRef
		 * @param {Object} mediaData
		 *
		 */
		GraphicSelectApp.prototype.EmbedMedia = function (type, containerRef, mediaData) {
			var GS_audioButton, mediaDomContent, mediaDomLink, mediaDomObj, validSrc;
			mediaDomContent = void 0;
			mediaDomLink = void 0;
			validSrc = void 0;
			mediaDomObj = document.createElement('div');
			mediaDomObj.setAttribute('class', 'GS_Media');
			if (type === 'feedback') {
				$(mediaDomObj).addClass('feedbackMedia');
			} else if (type === 'page') {
				$(mediaDomObj).addClass('pageMedia');
			}
			switch (mediaData.type) {
			case 'link':
				mediaDomContent = document.createElement('a');
				mediaDomContent.setAttribute('class', 'GS_MediaLink');
				mediaDomContent.setAttribute('href', mediaData.src);
				mediaDomContent.setAttribute('target', '_blank');
				if (mediaData.description) {
					mediaDomContent.innerHTML = mediaData.description;
				} else {
					mediaDomContent.innerHTML = 'Link';
				}
				mediaDomObj.appendChild(mediaDomContent);
				break;
			case 'audio':
				mediaDomContent = document.createElement('audio');
				mediaDomContent.id = mediaData.id;
				mediaDomContent.setAttribute('class', 'GS_MediaAudio');
				mediaDomContent.setAttribute('target', '_blank');
				mediaDomContent.innerHTML = '<source src="' + mediaData.mp3 + '" type="audio/mpeg">' + '<source src="' + mediaData.ogg + '" type="audio/ogg">' + '<source src="' + mediaData.wav + '" type="audio/wav"> Your browser does not support the audio tag.';
				mediaDomObj.appendChild(mediaDomContent);
				GS_audioButton = document.createElement('button');
				GS_audioButton.setAttribute('class', 'GS_audioButton');
				GS_audioButton.setAttribute('title', 'Play Audio Button');
				GS_audioButton.onclick = function () {
					var audioClip;
					audioClip = document.getElementById(mediaData.id);
					audioClip.play();
				};
				mediaDomObj.appendChild(GS_audioButton);
				break;
			case 'image':
				if (mediaData.mediaLink !== 'none' && mediaData.mediaLink !== null && mediaData.mediaLink !== void 0 && mediaData.mediaLink !== '') {
					mediaDomLink = document.createElement('a');
					mediaDomLink.setAttribute('class', 'GS_MediaImageLink');
					mediaDomLink.setAttribute('href', mediaData.mediaLink);
					mediaDomLink.setAttribute('target', '_blank');
				}
				mediaDomContent = document.createElement('img');
				mediaDomContent.setAttribute('class', 'GS_MediaImage embedMedia');
				mediaDomContent.setAttribute('src', mediaData.src);
				if (mediaData.width !== 'none') {
					mediaDomContent.setAttribute('width', mediaData.width);
				} else {
					mediaDomContent.setAttribute('width', '420');
				}
				if (mediaData.height !== 'none') {
					mediaDomContent.setAttribute('height', mediaData.height);
				} else {
					mediaDomContent.setAttribute('height', '315');
				}
//				mediaDomObj.setAttribute('style', 'text-align:center;');
					
				if (mediaData.description) {
					mediaDomContent.setAttribute('alt', mediaData.description);
				}
				mediaDomContent.onerror = function () {
					mediaDomContent.setAttribute('src', '../../_assets/iats/multiselect/img/placeholder-error.png');
					mediaDomContent.setAttribute('alt', 'Error. Image could not be loaded.');
				};
				mediaDomContent.onload = (function (_this) {
					return function () {
						return _this.HandleResizeEvent();
					};
				})(this);
				if (mediaData.mediaLink === 'none' || mediaData.mediaLink === null || mediaData.mediaLink === void 0 || mediaData.mediaLink === '') {
					mediaDomObj.appendChild(mediaDomContent);
				} else {
					mediaDomLink.appendChild(mediaDomContent);
					mediaDomObj.appendChild(mediaDomLink);
				}
				break;
			case 'YouTubeVideo':
				validSrc = this.validateYouTubeLink(mediaData.src);
				if (validSrc) {
					mediaDomContent = document.createElement('iframe');
					mediaDomContent.setAttribute('class', 'GS_MediaEmbeddedVideo embedMedia');
					if (mediaData.width !== 'none') {
						mediaDomContent.setAttribute('width', mediaData.width);
					} else {
						mediaDomContent.setAttribute('width', '420');
					}
					if (mediaData.height !== 'none') {
						mediaDomContent.setAttribute('height', mediaData.height);
					} else {
						mediaDomContent.setAttribute('height', '315');
					}
					mediaDomContent.setAttribute('frameborder', '0');
					mediaDomContent.setAttribute('allowfullscreen', 'true');
					mediaDomContent.setAttribute('src', validSrc);
//					if (type === 'page') {
//						mediaDomObj.setAttribute('style', 'text-align:center;');
//					}
					if (mediaData.description) {
						mediaDomContent.setAttribute('alt', mediaData.description);
					}
					mediaDomObj.appendChild(mediaDomContent);
					mediaDomLink = document.createElement('a');
					mediaDomLink.setAttribute('class', 'GS_MediaAltLink');
					mediaDomLink.setAttribute('href', mediaData.altLink);
					mediaDomLink.setAttribute('target', '_blank');
//					mediaDomLink.innerHTML = 'Alternate Link.';
					mediaDomLink.innerHTML = 'Direct Link';
					mediaDomObj.appendChild(mediaDomLink);
				} else {
					mediaDomContent = document.createElement('img');
					mediaDomContent.setAttribute('class', 'GS_MediaImage embedMedia');
					mediaDomContent.setAttribute('src', '../../_assets/iats/multiselect/img/placeholder-error.png');
					mediaDomContent.setAttribute('alt', 'Error. Video could not be loaded.');
					mediaDomContent.setAttribute('width', '420');
					mediaDomContent.setAttribute('width', '360');
//					if (type === 'page') {
//						mediaDomObj.setAttribute('style', 'text-align:center;');
//					}
					mediaDomObj.appendChild(mediaDomContent);
				}
				break;
			case 'text':
				mediaDomContent = document.createElement('p');
				mediaDomContent.setAttribute('class', 'GS_MediaText');
				mediaDomContent.setAttribute('target', '_blank');
				mediaDomContent.innerHTML = mediaData.content;
				mediaDomObj.appendChild(mediaDomContent);
				break;
			default:
				break;
			}
			$(mediaDomObj).hide().appendTo(containerRef).fadeIn(500);
			// containerRef.appendChild(mediaDomObj);
		};
		/**
		 *
		 * Takes the passed string and checks to see if it is a valid YouTube link.
		 *
		 * @method validateYouTubeLink
		 *
		 * @param {String} src
		 *
		 * @return {String} A valid Youtube link (if it validates).
		 *
		 */
		GraphicSelectApp.prototype.validateYouTubeLink = function (src) {
			var code;
			code = void 0;
			if (src.indexOf('www.youtube.com') !== -1) {
				if (src.indexOf('</iframe>') === -1) {
					if (src.indexOf('watch?v=') !== -1) {
						code = src.slice(src.indexOf('?v=') + 3);
						return 'https://www.youtube.com/embed/' + code;
					} else {
						return false;
					}
				} else {
					if (src.indexOf('https://www.youtube.com/embed/') !== -1) {
						return src.slice(src.indexOf('src') + 5, src.indexOf('"', src.indexOf('src') + 5));
					} else {
						return false;
					}
				}
			} else {
				return false;
			}
		};
		/**
		 *
		 * Takes the passed array and shuffles it into a random order.
		 *
		 * @method shuffle
		 *
		 * @param {Array} o, array to shuffle
		 *
		 * @return {Array} Shuffled array
		 *
		 */
		GraphicSelectApp.prototype.shuffle = function (o) {
			var i, j, x;
			j = void 0;
			x = void 0;
			i = o.length;
			while (i) {
				j = Math.floor(Math.random() * i);
				x = o[--i];
				o[i] = o[j];
				o[j] = x;
			}
			return o;
		};
		/**
		 *
		 * Checks for all correct answers in GraphicSelectApp
		 *
		 * @method buildAnswerReferences
		 *
		 */
		GraphicSelectApp.prototype.buildAnswerReferences = function () {
			var correct, i, j;
			i = 0;
			while (i < this.Questions.length) {
				this._questionCheck = [];
				this._correctAnswers = [];
				j = 0;
				while (j < this._appData.Answers.length) {
					correct = false;
					if (this.Questions[i].answers[j].check === true) {
						correct = true;
					}
					this._questionCheck.push(false);
					this._correctAnswers.push(correct);
					j++;
				}
				this._allCheck.push(this._questionCheck);
				this._allCorrect.push(this._correctAnswers);
				i++;
			}
		};
		/**
		 *
		 * Checks to see if browser is IE
		 *
		 * @method msieversion
		 *
		 * @return {Boolean} is IE
		 *
		 */
		GraphicSelectApp.prototype.msieversion = function () {
			var msie, ua;
			ua = window.navigator.userAgent;
			msie = ua.indexOf('MSIE ');
			if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)) {
				return true;
			} else {
				return false;
			}
		};
		/**
		 * Generic D2L logging method. Used to try and prevent large amounts of console logging in production
		 *
		 * @method d2log
		 * @param {string} m
		 * @return {} Console logs m
		 */
		GraphicSelectApp.prototype.d2log = function (m) {
			if (typeof D2LDEBUG !== 'undefined') {
				if (D2LDEBUG) {
					console.log(m);
				}
			}
		};
		/**
		 *  
		 * Another utility function, this one merges all the properties of object one into object two, with object one taking priority.
		 *
		 * @method mergeObjectData
		 *
		 * @param {Object} obj1 any JS object, this one will take priority, meaning if object 2 has a property of the same name 
		 *                 or a property in this object, the property in object 2  it will be ignored.
		 *
		 * @param {Object} obj2 any JS object
		 *
		 * @return {Object} The resulting merged object.  
		 *
		 *
		 */
		GraphicSelectApp.prototype.mergeObjectData = function (obj1, obj2) {
			var k, obj3;
			obj3 = obj1;
			if (obj2.constructor === void 0 || obj2.constructor === null) {
				return obj3;
			} else if (obj2.constructor === Object) {
				k = 0;
				while (k < Object.keys(obj2).length) {
					if (obj3[Object.keys(obj2)[k]] === void 0) {
						obj3[Object.keys(obj2)[k]] = obj2[Object.keys(obj2)[k]];
					} else if (typeof obj3[Object.keys(obj2)[k]] === "object") {
						this.mergeObjectData(obj3[Object.keys(obj2)[k]], obj2[Object.keys(obj2)[k]]);
					}
					k++;
				}
			} else {
				return obj2;
			}
			return obj3;
		};
		/**
		 *  
		 * Handle reszing for the LE
		 *
		 * @method mergeObjectData
		 *
		 *
		 *
		 */
		GraphicSelectApp.prototype.HandleResizeEvent = function () {
			var bnds, error;
			try {
				bnds = window.document.body.getBoundingClientRect();
				return window.parent.document.getElementsByTagName("iframe")[0].style.height = (bnds.height + bnds.top + 20) + "px";
			} catch (error) {
				return this.d2log("Resize Error: Not in LE.");
			}
		};
		/**
		 *
		 * Scrolls the view to the top of LE content. 
		 *  - Lessons experience automatically scroll to top
		 *
		 * @method scrollViewToTop
		 *
		 */
		GraphicSelectApp.prototype.scrollViewToTop = function () {
			var scrollTargetID = "dbox";
			var scrollTarget = document.getElementById(scrollTargetID);
			var TargetID = '#'+ scrollTargetID;
			var scrollToTop = scrollTarget.scrollIntoView();
			if ($("#ContentView", window.parent.document).length > 0) {
			 $('html, body', window.parent.document).scrollTop($(TargetID).offset().top + $('#ContentView', window.parent.document).offset().top);
		 }
		 else {
			 scrollToTop;
		 }
			
		}
		
		return GraphicSelectApp;
	})();
}).call(this);